#ifndef _MATRIX_COMPLEX_H
#define _MATRIX_COMPLEX_H

#include <iostream.h>
#include <math.h>
#include "element.h"
#include "classes.h"

class Complex:public Element
{
	private:

		float real;
		float imaginary;

	public:

		Complex(Complex &);
		Complex(float, float);
		~Complex();

		virtual Element& operator+(Element &element);
		virtual Element& operator-(Element &element);
		virtual Element& operator-();
		virtual Element& operator*(Element &element);

		float   getReal() { return real; };
		float   getImaginary() { return imaginary; };
		virtual float getNum() {
			return (float) sqrt(real * real + imaginary * imaginary);
		};
		virtual Element& copy();
		virtual int getClass() { return classComplex; };

		virtual ostream & toStream(ostream &out);
};

#endif /* #ifndef _MATRIX_COMPLEX_H */

