#ifndef _MATRIX_ELEMENT_H
#define _MATRIX_ELEMENT_H

#include <iostream.h>

class Element
{
	public:

		Element() {};
		~Element() {};

		virtual Element& operator+(Element &element) = 0;
		virtual Element& operator-(Element &element) = 0;
		virtual Element& operator-()                 = 0;
		virtual Element& operator*(Element &element) = 0;
		virtual Element& operator=(Element &element) {
			return element.copy();
		};

		virtual float getNum()  = 0;
		virtual Element& copy() = 0;
		virtual int getClass()  = 0;

		virtual ostream & toStream(ostream &out) { return out; };
		friend ostream & operator <<(ostream &out, Element &element);
};

#endif /* #ifndef _MATRIX_ELEMENT_H */

