#ifndef _MATRIX_MATRIX_H
#define _MATRIX_MATRIX_H

#include "element.h"
#include "number.h"
#include "classes.h"

class Matrix:public Element
{
	private:

		Number ***cell;
		int rows, cols;

	public:

		Matrix(int);
		Matrix(int, int);
		Matrix(Matrix &);
		Matrix(Element &);
		Matrix(int, int, Element &);
		Matrix(char *, int);
		~Matrix();

		Number& operator () (int row, int col);

		virtual Element& operator+(Element &element);
		virtual Element& operator-(Element &element);
		virtual Element& operator-();
		virtual Element& operator*(Element &element);

		virtual Element& scalarMultiply(Element &element);

		virtual float getNum();
		virtual Element& copy();
		virtual int getClass() { return classMatrix; };
		virtual ostream & toStream(ostream &out);

		int		getRows() { return rows; };
		int		getCols() { return cols; };
		float   determinant();
		Matrix& inverse();

	private: /* private methods */

		void    remove(int row, int col) { delete cell[row - 1][col - 1]; };
		void    createType(char *type);
		void    createNumbers(int a_rows, int a_cols);
		void    fillNumbers(int value);
		Matrix& subMatrix(int j,int k);
};

#endif /* #ifndef _MATRIX_MATRIX_H */

