#ifndef _MATRIX_NUMBER_H
#define _MATRIX_NUMBER_H

#include <iostream.h>
#include "element.h"

class Number
{
	private:

		Element *element;

	public:

		Number(Element &);
		Number(Number &);
		Number(float);
		~Number();

		virtual Number& operator+(Number &a_element);
		virtual Number& operator-(Number &a_element);
		virtual Number& operator-();
		virtual Number& operator*(Number &a_element);
		virtual Number& operator=(Number &a_element);

		virtual Number& operator+(Element &a_element);
		virtual Number& operator-(Element &a_element);
		virtual Number& operator*(Element &a_element);
		virtual Number& operator=(Element &a_element);
		virtual Number& operator=(double a_double);

		virtual float getNum();
		virtual Number& copy();
		virtual int getClass();

		Element& getElement() { return *element; };
		Element& copyElement();

		friend ostream & operator <<(ostream &stream, Number &number);
};

#endif /* #ifndef _MATRIX_NUMBER_H */

