unit PisqGameUnit;

interface

uses Windows,Grids,PisqTableUnit,PisqAlgUnit,PisqAlgFirstUnit,PisqAlgRandomUnit;

const
  { onMove consts }
  cPisqPlayer1=1;
  cPisqPlayer2=2;
  cPisqEndGame=255;

  { PlayerX consts }
  cPisqHuman=1;
  cPisqCPUPoor=2;
  cPisqCPUGood=3;

type
  TPisqGame=class
    private
      onMove:byte;
      Player:array[cPisqPlayer1..cPisqPlayer2]of byte;
      table:TPisqTable;
      dgrid:TDrawGrid;
      algPoor,algGood:TPisqAlg;
      procedure DrawGridDrawCell(Sender:TObject;ACol,ARow:Integer;Rect:TRect;State:TGridDrawState);
    public
      constructor Create(const x,y:integer);overload;
      constructor Create(const x,y:integer;const dg:TDrawGrid);overload;
      destructor Destroy;override;

      procedure Start;
      procedure HumanMove(const x,y:integer);
      procedure CPUMove;
      procedure SwitchMove;

      procedure SetSize(const x,y:integer);
      procedure SetPlayer1(const p:byte);
      procedure SetPlayer2(const p:byte);
      procedure SetPlayers(const p1,p2:byte);
      procedure SetDrawGrid;overload;
      procedure SetDrawGrid(const dg:TDrawGrid);overload;

      function GetPlayer1:byte;
      function GetPlayer2:byte;
      function GetWidth:integer;
      function GetHeight:integer;
      function GetOnMove:byte;
      function GetWinner:byte;

      function Save(const filename:string):boolean;
      function Load(const filename:string):boolean;

  end;

implementation

uses Dialogs,Classes,Sysutils,Graphics;

procedure TPisqGame.DrawGridDrawCell(Sender:TObject;ACol,ARow:Integer;Rect:TRect;State:TGridDrawState);
var
  r:TRect;
begin
  r:=rect;
  r.Left:=r.Left+((r.Right-r.Left) div 4);
  r.Right:=r.Right-((r.Right-r.Left) div 4);
  r.Top:=r.Top+((r.Bottom-r.Top) div 4);
  r.Bottom:=r.Bottom-((r.Bottom-r.Top) div 4);

  dgrid.Canvas.Pen.Width:=dgrid.DefaultColWidth div 10;
  if(dgrid.Canvas.Pen.Width<2)then dgrid.Canvas.Pen.Width:=2;

  case table.GetCell(aCol,aRow) of
    cPisqEmpty:begin
      dgrid.Canvas.Brush.Color:=clBlack;
      dgrid.Canvas.FillRect(rect);
    end;
    cPisqCircle,cPisqCircle+3:begin
      if table.GetCell(aCol,aRow)=cPisqCircle then dgrid.Canvas.Brush.Color:=clDkGray
      else dgrid.Canvas.Brush.Color:=clLtGray;
      dgrid.Canvas.FillRect(rect);

      dgrid.Canvas.Pen.Color:=clRed;
      dgrid.Canvas.Ellipse(r);
    end;
    cPisqCross,cPisqCross+3:begin
      if table.GetCell(aCol,aRow)=cPisqCross then dgrid.Canvas.Brush.Color:=clDkGray
      else dgrid.Canvas.Brush.Color:=clLtGray;
      dgrid.Canvas.FillRect(rect);

      dgrid.Canvas.Pen.Color:=clLime;
      dgrid.Canvas.MoveTo(r.Left,r.Top);
      dgrid.Canvas.LineTo(r.Right,r.Bottom);
      dgrid.Canvas.MoveTo(r.Right,r.Top);
      dgrid.Canvas.LineTo(r.Left,r.Bottom);
    end;
  else
    dgrid.Canvas.Brush.Color:=clRed;
    dgrid.Canvas.FillRect(rect);
  end;
end;

constructor TPisqGame.Create(const x,y:integer);
begin
  onMove:=cPisqPlayer1;
  Player[cPisqPlayer1]:=cPisqCPUGood;
  Player[cPisqPlayer2]:=cPisqCPUGood;
  dgrid:=nil;
  algPoor:=TPisqAlgRandom.Create;
  algGood:=TPisqAlgFirst.Create;
  table:=TPisqTable.Create(x,y);
end;

constructor TPisqGame.Create(const x,y:integer;const dg:TDrawGrid);
begin
  Create(x,y);
  SetDrawGrid(dg);
end;

destructor TPisqGame.Destroy;
begin
  table.Free;
  algPoor.Free;
  algGood.Free;

  inherited;
end;

procedure TPisqGame.Start;
begin
  table.Clear;
  onMove:=cPisqPlayer1;

  dgrid.Refresh;
end;

procedure TPisqGame.HumanMove(const x,y:integer);
begin
  if(table.IsEmpty(x,y))then begin
    table.SetCell(x,y,onMove);
    dgrid.Refresh;
    SwitchMove;
  end;
end;

procedure TPisqGame.CPUMove;
var
  x,y:integer;
begin
  if Player[onMove]=cPisqCPUPoor then algPoor.Move(x,y,cPisqCircle,table)
  else algGood.Move(x,y,cPisqCircle,table);

  if(table.IsEmpty(x,y))then begin
    table.SetCell(x,y,onMove);
    dgrid.Refresh;
    SwitchMove;
  end
  else begin
    showMessage('CPU vykonal nepovoleny tah!');
  end;
end;

procedure TPisqGame.SwitchMove;
begin
  if GetWinner=cPisqNoWinner then begin
    if onMove=cPisqPlayer1 then onMove:=cPisqPlayer2
    else onMove:=cPisqPlayer1;
  end
  else begin
    onMove:=cPisqEndGame;
  end;
end;

procedure TPisqGame.SetSize(const x,y:integer);
begin
  table.SetSize(x,y);
  SetDrawGrid;
end;

procedure TPisqGame.SetPlayer1(const p:byte);
begin
  if p=cPisqHuman then player[cPisqPlayer1]:=cPisqHuman
  else if p=cPisqCPUPoor then player[cPisqPlayer1]:=cPisqCPUPoor
  else player[cPisqPlayer1]:=cPisqCPUGood;
end;

procedure TPisqGame.SetPlayer2(const p:byte);
begin
  if p=cPisqHuman then player[cPisqPlayer2]:=cPisqHuman
  else if p=cPisqCPUPoor then player[cPisqPlayer2]:=cPisqCPUPoor
  else player[cPisqPlayer2]:=cPisqCPUGood;
end;

procedure TPisqGame.SetPlayers(const p1,p2:byte);
begin
  SetPlayer1(p1);
  SetPlayer2(p2);
end;

procedure TPisqGame.SetDrawGrid;
begin
  if(dgrid<>nil)then begin
    with dgrid do begin
      FixedCols:=0;
      FixedRows:=0;

      ColCount:=table.GetWidth;
      RowCount:=table.GetHeight;

//      GridLineWidth:=(dgrid.DefaultColWidth div 10)-1;
//      if(GridLineWidth<1)then GridLineWidth:=1;
      GridLineWidth:=2;

      DefaultColWidth:=(Width-(GridLineWidth*(ColCount+1))) div ColCount;
      DefaultRowHeight:=(Height-(GridLineWidth*(RowCount+1))) div RowCount;

      OnDrawCell:=DrawGridDrawCell;
    end;
  end;
end;

procedure TPisqGame.SetDrawGrid(const dg:TDrawGrid);
begin
  dgrid:=dg;
  SetDrawGrid;
end;

function TPisqGame.GetPlayer1:byte;
begin
  Result:=Player[cPisqPlayer1];
end;

function TPisqGame.GetPlayer2:byte;
begin
  Result:=Player[cPisqPlayer2];
end;

function TPisqGame.GetWidth:integer;
begin
  Result:=table.GetWidth;
end;

function TPisqGame.GetHeight:integer;
begin
  Result:=table.GetHeight;
end;

function TPisqGame.GetOnMove:byte;
begin
  if onMove=cPisqEndGame then Result:=cPisqEndGame
  else Result:=Player[onMove];
end;

function TPisqGame.GetWinner:byte;
begin
  Result:=table.GetWinner;
  if result<>cPisqNoWinner then onMove:=cPisqEndGame;
end;

function TPisqGame.Save(const filename:string):boolean;
var
  f:TStream;
begin
  f:=TFileStream.Create(filename,fmCreate);
  f.WriteBuffer(onMove,sizeof(onMove));
  f.WriteBuffer(Player[cPisqPlayer1],sizeof(Player[cPisqPlayer1]));
  f.WriteBuffer(Player[cPisqPlayer2],sizeof(Player[cPisqPlayer2]));
  table.WriteToStream(f);
  f.Free;
  Result:=true;
end;

function TPisqGame.Load(const filename:string):boolean;
var
  f:TStream;
begin
  f:=TFileStream.Create(filename,fmOpenRead);
  f.ReadBuffer(onMove,sizeof(onMove));
  f.ReadBuffer(Player[cPisqPlayer1],sizeof(Player[cPisqPlayer1]));
  f.ReadBuffer(Player[cPisqPlayer2],sizeof(Player[cPisqPlayer2]));
  table.ReadFromStream(f);
  f.Free;
  Result:=true;
end;

end.
