unit PisqUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids,PisqGameUnit,PisqAlgFirstUnit, ExtCtrls, Menus;

type
  TPisqForm = class(TForm)
    DrawGrid: TDrawGrid;
    MainMenu: TMainMenu;
    GameMI: TMenuItem;
    StartMI: TMenuItem;
    QuitMI: TMenuItem;
    N1: TMenuItem;
    N3: TMenuItem;
    SaveMI: TMenuItem;
    LoadMI: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    HelpMI: TMenuItem;
    AboutMI: TMenuItem;
    GuideMI: TMenuItem;
    OptionsMI: TMenuItem;
    PauseMI: TMenuItem;
    Timer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCanResize(Sender: TObject; var NewWidth,
      NewHeight: Integer; var Resize: Boolean);
    procedure DrawGridSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure StartMIClick(Sender: TObject);
    procedure LoadMIClick(Sender: TObject);
    procedure SaveMIClick(Sender: TObject);
    procedure QuitMIClick(Sender: TObject);
    procedure AboutMIClick(Sender: TObject);
    procedure GuideMIClick(Sender: TObject);
    procedure OptionsMIClick(Sender: TObject);
    procedure PauseMIClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    game:TPisqGame;
    paused:boolean;
    procedure CPUMove;
    procedure CheckWinners;
  public
  end;

var
  PisqForm: TPisqForm;

implementation

{$R *.DFM}

uses PisqTableUnit, AboutFormUnit, GuideFormUnit, OptionsFormUnit;

procedure TPisqForm.CPUMove;
begin
  game.CPUMove;
  Application.ProcessMessages;
end;

procedure TPisqForm.CheckWinners;
begin
    case game.GetWinner of
      cPisqNoWinner:begin
      end;
      cPisqDrawGame:begin
        showMessage('Remiza!');
      end;
      cPisqCross:begin
        showMessage('Vyhral HRAC 1');
      end;
      cPisqCircle:begin
        showMessage('Vyhral HRAC 2');
      end;
    end;
end;

procedure TPisqForm.FormCreate(Sender: TObject);
begin
  game:=TPisqGame.Create(20,20,DrawGrid);
  game.SetPlayer1(cPisqHuman);

  StartMIClick(sender);
end;

procedure TPisqForm.FormDestroy(Sender: TObject);
begin
  game.Free;
end;

procedure TPisqForm.FormCanResize(Sender: TObject; var NewWidth,
  NewHeight: Integer; var Resize: Boolean);
begin
  game.SetDrawGrid;
end;

procedure TPisqForm.DrawGridSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  if paused then exit;
  if (game.GetWinner=cPisqNoWinner) then begin
    if(game.GetOnMove=cPisqHuman) then begin
      game.HumanMove(ACol,ARow);
      CheckWinners;
    end
    else begin
      //messageBeep
    end;
  end;
end;

procedure TPisqForm.StartMIClick(Sender: TObject);
begin
  paused:=true; // musi byt opacne
  PauseMIClick(sender);
  game.Start;
  Timer.Enabled:=true;
end;

procedure TPisqForm.LoadMIClick(Sender: TObject);
var
  s:string;
begin
  GetDir(0,s);
  OpenDialog.InitialDir:=s;
  if OpenDialog.Execute then begin
    s:=OpenDialog.FileName;
    if not game.Load(s) then ShowMessage('Chyba pri nacitavani zo suboru '''+s+'''.')
    else ShowMessage('Hra bola uspesne nacitana.');
  end;
end;

procedure TPisqForm.SaveMIClick(Sender: TObject);
var
  s:string;
begin
  GetDir(0,s);
  SaveDialog.InitialDir:=s;
  if SaveDialog.Execute then begin
    s:=SaveDialog.FileName;
    if not game.Save(s) then ShowMessage('Chyba pri ukladani do suboru '''+s+'''.')
    else ShowMessage('Hra bola uspesne ulozena.');
  end;
end;

procedure TPisqForm.QuitMIClick(Sender: TObject);
begin
  halt;
end;

procedure TPisqForm.AboutMIClick(Sender: TObject);
begin
  AboutForm.ShowModal;
end;

procedure TPisqForm.GuideMIClick(Sender: TObject);
begin
   GuideForm.ShowModal;
end;

procedure TPisqForm.OptionsMIClick(Sender: TObject);
begin
  case game.GetPlayer1 of
    cPisqHuman:OptionsForm.p1HumanRadioButton.Checked:=true;
    cPisqCPUPoor:OptionsForm.p1CPUPoorRadioButton.Checked:=true;
    cPisqCPUGood:OptionsForm.p1CPUGoodRadioButton.Checked:=true;
  end;

  case game.GetPlayer2 of
    cPisqHuman:OptionsForm.p2HumanRadioButton.Checked:=true;
    cPisqCPUPoor:OptionsForm.p2CPUPoorRadioButton.Checked:=true;
    cPisqCPUGood:OptionsForm.p2CPUGoodRadioButton.Checked:=true;
  end;

  OptionsForm.ShowModal;

  if OptionsForm.ModalResult=mrOK then begin
    if OptionsForm.p1HumanRadioButton.Checked=true then game.SetPlayer1(cPisqHuman);
    if OptionsForm.p1CPUPoorRadioButton.Checked=true then game.SetPlayer1(cPisqCPUPoor);
    if OptionsForm.p1CPUGoodRadioButton.Checked=true then game.SetPlayer1(cPisqCPUGood);

    if OptionsForm.p2HumanRadioButton.Checked=true then game.SetPlayer2(cPisqHuman);
    if OptionsForm.p2CPUPoorRadioButton.Checked=true then game.SetPlayer2(cPisqCPUPoor);
    if OptionsForm.p2CPUGoodRadioButton.Checked=true then game.SetPlayer2(cPisqCPUGood);
  end;
end;

procedure TPisqForm.PauseMIClick(Sender: TObject);
begin
  if paused=false then begin
    PauseMI.Caption:='&Pokraova';
    paused:=true;
  end
  else begin
    PauseMI.Caption:='&Pozastavi';
    paused:=false;
  end;
end;

procedure TPisqForm.TimerTimer(Sender: TObject);
begin
   Timer.Enabled:=false;

   if not paused then begin
     if (game.GetOnMove<>cPisqHuman)and(game.GetOnMove<>cPisqEndGame) then
       CPUMove;
       CheckWinners;
       if game.GetWinner<>cPisqNoWinner then exit;
   end;

   Timer.Enabled:=true;
end;

end.
