unit PisqTableUnit;

interface

uses Classes;

const
  { Konstanty pre hacie pole. }
  cPisqEmpty=0;
  cPisqCross=1;
  cPisqCircle=2;
  cPisqWall=3;
  { Konstanty pre vytazov. }
  cPisqNoWinner=0;
  cPisqNothing=0;
  cPisqCrossWin=1;
  cPisqCircleWin=2;
  cPisqDrawGame=3;
  { Pomocne konstanty pre zistovanie vyherneho stavu. }
  cPisqSX:array[1..4]of shortint=(1,0,1,1);
  cPisqSY:array[1..4]of shortint=(0,1,1,-1);

type
  TPisqTable=class
    private
      winner:byte;
      cell:array of array of byte;
    public
      constructor Create;overload;
      constructor Create(const x,y:integer);overload;
      destructor Destroy;override;

      procedure Clear;

      function IsXInRange(const x:integer):boolean;
      function IsYInRange(const y:integer):boolean;
      function IsFull:boolean;
      function IsEmpty:boolean;overload;
      function IsEmpty(const x,y:integer):boolean;overload;
      function IsValid:boolean;

      procedure SetSize(const x,y:integer);
      procedure SetCell(const x,y:integer;const z:byte);

      function GetWidth:integer;
      function GetHeight:integer;
      function GetCell(const x,y:integer):byte;
      function GetWinner:byte;

      procedure WriteToStream(f:TStream);
      procedure ReadFromStream(f:TStream);
  end;

implementation

constructor TPisqTable.Create;
begin
  inherited;
  cell:=nil;
  SetSize(0,0);
end;

constructor TPisqTable.Create(const x,y:integer);
begin
  Create;
  SetSize(x,y);
end;

destructor TPisqTable.Destroy;
var
  k:integer;
begin
  for k:=0 to GetWidth-1 do setLength(cell[k],0);
  setLength(cell,0);

  inherited;
end;

procedure TPisqTable.Clear;
var
  k,l:integer;
begin
  for k:=0 to GetWidth-1 do begin
    for l:=0 to GetHeight-1 do begin
      cell[k,l]:=cPisqEmpty;
    end;
  end;
  winner:=cPisqNoWinner;
end;

function TPisqTable.IsXInRange(const x:integer):boolean;
begin
  Result:=((x>=0)and(x<GetWidth));
end;

function TPisqTable.IsYInRange(const y:integer):boolean;
begin
  Result:=((y>=0)and(y<GetHeight));
end;

function TPisqTable.IsFull:boolean;
var
  k,l:integer;
begin
  Result:=true;
  for k:=0 to GetWidth-1 do begin
    for l:=0 to GetHeight-1 do begin
      if cell[k,l]=cPisqEmpty then Result:=false;
    end;
  end;
end;

function TPisqTable.IsEmpty:boolean;
var
  k,l:integer;
begin
  Result:=true;
  for k:=0 to GetWidth-1 do begin
    for l:=0 to GetHeight-1 do begin
      if cell[k,l]<>cPisqEmpty then Result:=false;
    end;
  end;
end;
function TPisqTable.IsEmpty(const x,y:integer):boolean;
begin
  Result:=(x>=0)and(x<=GetWidth)and(y>=0)and(y<=GetHeight)and(cell[x,y]=cPisqEmpty);
end;

function TPisqTable.IsValid:boolean;
var
  k,l:integer;
begin
  Result:=true;
  for k:=0 to GetWidth-1 do begin
    for l:=0 to GetHeight-1 do begin
      if(cell[k,l]<>cPisqEmpty)and(cell[k,l]<>cPisqCross)and(cell[k,l]<>cPisqCircle)then Result:=false;
    end;
  end;
end;

procedure TPisqTable.SetSize(const x,y:integer);
var
  k:integer;
begin
  setLength(cell,x);
  for k:=0 to x-1 do setLength(cell[k],y);
end;

procedure TPisqTable.SetCell(const x,y:integer;const z:byte);
var
  i,j,k,l:integer;
begin
  if(x<=GetWidth)and(y<=GetHeight)then begin
    cell[x,y]:=z;

    if winner=cPisqNowinner then begin
      for i:=1 to 4 do for j:=0 to 4 do begin

        for k:=0 to 5 do begin
          if k=5 then begin
            winner:=z;
            { Zvyraznenie vyhernych policok. }
            { Zatial bez efektu. }
            for l:=0 to 4 do begin
              cell[x+cPisqSX[i]*(j-l),y+cPisqSY[i]*(j-l)]:=z+3;
            end;
          end
          else if GetCell(x+cPisqSX[i]*(j-k),y+cPisqSY[i]*(j-k))<>z then break;
        end;
      end;

      if (winner=cPisqNoWinner)and(IsFull) then winner:=cPisqDrawGame;
    end;
  end;
end;


function TPisqTable.GetWidth:integer;
begin
  Result:=Length(cell);
end;

function TPisqTable.GetHeight:integer;
begin
  if(Length(cell)>0)then Result:=Length(cell[0])
  else Result:=0;
end;

function TPisqTable.GetCell(const x,y:integer):byte;
begin
  if(IsXInRange(x))and(IsYInRange(y))then Result:=cell[x,y]
  else Result:=cPisqWall;
end;

function TPisqTable.GetWinner:byte;
begin
  Result:=winner;
end;

procedure TPisqTable.WriteToStream(f:TStream);
var
  x,y:integer;
begin
  x:=GetWidth;
  y:=GetHeight;
  f.WriteBuffer(x,sizeof(integer));
  f.WriteBuffer(y,sizeof(integer));

  for x:=0 to GetWidth-1 do begin
    for y:=0 to GetHeight-1 do begin
      f.WriteBuffer(cell[x,y],sizeof(cell[x,y]));
    end;
  end;
end;

procedure TPisqTable.ReadFromStream(f:TStream);
var
  x,y:integer;
begin
  f.ReadBuffer(x,sizeof(integer));
  f.ReadBuffer(y,sizeof(integer));
  SetSize(x,y);

  for x:=0 to GetWidth-1 do begin
    for y:=0 to GetHeight-1 do begin
      f.ReadBuffer(cell[x,y],sizeof(cell[x,y]));
    end;
  end;
end;

end.
